<?php
/**
 * Module Name: WooCommerce Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( class_exists( 'Woocommerce' ) ) :

 //*************** Actions ***************\\
 add_action('woocommerce_order_status_completed', 'wpachievements_wc_order_complete', 10, 1);
 //*************** Detect order completed ***************\\
 function wpachievements_wc_order_complete( $order_id ){
    // return for no valid order_id
    if ( ! $order_id ) {
      return;
    }

    $order = wc_get_order( $order_id );

    $order_user_id = version_compare( WC_VERSION, '3.0', '<' ) ? $order->user_id : $order->get_user_id();

    // return for guest users
    if ( ! $order_user_id ) {
      return;
    }

    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'wc_order_complete',
      'user_id'     => $order_user_id,
      'post_id'     => $order_id,
      'points'      => (int) wpachievements_get_site_option('wpachievements_wc_order_complete'),
    ) );    

    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'wc_user_spends',
      'user_id'     => $order_user_id,
      'post_id'     => $order_id,
      'points'      => 0,
    ) );     
 }

  /**
   * Check if we have a valid activity
   *
   * @param   bool $proceed True on valid activity
   * @param   string $type
   * @param   int $uid
   * @param   int $postid
   * @param   int $ach_ID
   * @return  bool
   */
  function wpachievements_wc_check_actvity( $proceed, $type, $ach_ID, $postid, $uid ) {

    switch( $type ) {
      case 'wc_order_complete':
      case 'wc_user_spends': {
        $ach_woo_order_limit = intval( get_post_meta( $ach_ID, '_achievement_woo_order_limit', true ) );

        if ( $ach_woo_order_limit > 0 ) {
          $order = new WC_Order($postid);
          $order_total = $order->get_total();

          if ( $order_total < $ach_woo_order_limit ) {
            $proceed = false;
          }
        }
      } break;
    }
    WPAchievements()->logger()->add( 'log', __FUNCTION__ . " - wpachievements_wc_check_actvity: {$type}, user: {$uid}, post_id: {$postid}, ach_ID: {$ach_ID}, proceed: {$proceed}" );
    return $proceed;
  }
  add_filter( 'wpachievements_proceed_new_activity', 'wpachievements_wc_check_actvity', 10, 5 );

 //*************** Descriptions ***************\\
 add_filter('wpachievements_activity_description', 'achievement_wc_desc', 10, 4);
 function achievement_wc_desc($text='',$type='',$points='',$times=''){
  switch($type){
   case 'wc_order_complete': { $text = sprintf( _n( 'for making %s order', 'for making %s orders', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_quest_description', 'quest_wc_desc', 10, 3);
 function quest_wc_desc($text='',$type='',$times=''){
  switch($type){
   case 'wc_order_complete': { $text = sprintf( _n( 'Make %s order', 'Make %s orders', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

add_filter( 'wpachievements_get_sections_module', 'wpachievements_add_section_woocommerce' );
function wpachievements_add_section_woocommerce( $sections ) {
	$sections['woocommerce'] = __( 'WooCommerce', 'wpachievements' );
	return $sections;
}

//*************** Admin Settings ***************\\
add_filter('wpachievements_achievements_modules_admin_settings', 'wpachievements_wc_admin', 10, 3);
function wpachievements_wc_admin($defaultsettings, $shortname, $current_section){
  if ( $current_section == 'woocommerce' ) {
    $settings[] = array( 'title' => __( 'WooCommerce', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'WooCommerce_options' );

    $settings[] = array(
            'title'   => __( 'User Completes Orders', 'wpachievements' ),
            'desc'    => __( 'Points awarded when the users completes an order.', 'wpachievements' ),
            'id'      => $shortname.'_wc_order_complete',
            'type'    => 'text',
            'default' => '0',
          );

    $settings[] = array( 'type' => 'sectionend', 'id' => 'WooCommerce_options');

    return $settings;
  /**
  * If not, return the standard settings
  **/
	} else {
		return $defaultsettings;
	}
}

 //*************** Admin Events ***************\\
 add_filter('wpachievements_admin_events', 'achievement_wc_admin_events', 10);
 function achievement_wc_admin_events(){
   echo'<optgroup label="WooCommerce Events">
     <option value="wc_order_complete">'.__('The user completes an order', 'wpachievements').'</option>
     <option value="wc_user_spends">'.__('The user spends at least...', 'wpachievements').'</option>
   </optgroup>';
 }

 //*************** Admin Trigger Naming ***************\\
 add_filter('wpachievements_trigger_description', 'achievement_wc_admin_triggers', 1, 10);
 function achievement_wc_admin_triggers($trigger){

   switch($trigger){
     case 'wc_order_complete': { $trigger = __('The user completes an order', 'wpachievements'); } break;
     case 'wc_user_spends': { $trigger = __('The user spends at least...', 'wpachievements'); } break;
   }

   return $trigger;
 }
endif;
?>